<?php
define('IN_DISCUZ', true);
require_once '../../common.php';

// ================== 你的配置 ==================
$price        = 1;        // 1元/个
$days         = 7;        // 有效期7天
$max_per_day  = 100;      // 每日限量
$wx_qr        = "https://你的微信收款码URL"; // 替换成你的
$ali_qr       = "https://你的支付宝收款码URL"; // 替换成你的
// ==============================================

// 今日限购
$today = strtotime('today');
$count = DB::result_first("SELECT COUNT(*) FROM ".DB::table('common_invite')." WHERE dateline>$today");
if($count >= $max_per_day) {
    showmessage('今日邀请码已售罄，请明天再来！');
}

// 生成订单和邀请码
$order_no = 'O'.date('YmdHis').mt_rand(100,999);
$invitecode = random(16);
$endtime = TIMESTAMP + $days*86400;

// 插入数据库（适配你的表字段）
DB::insert('common_invite', [
    'uid'        => $_G['uid'],
    'code'       => $invitecode, // 兼容原生code字段
    'invitecode' => $invitecode, // 冗余存储，避免字段错误
    'dateline'   => TIMESTAMP,
    'endtime'    => $endtime,
    'fuid'       => 0,
    'fname'      => '',
    'status'     => 0,
    'order_no'   => $order_no
]);

// 页面展示
include template('common/header');
?>
<!DOCTYPE html>
<meta charset="utf-8">
<title>购买邀请码</title>
<meta name="viewport" content="width=device-width">
<style>
.main{max-width:400px;margin:50px auto;padding:25px;background:#fff;border-radius:12px;text-align:center;}
.price{font-size:28px;color:#ff3333;font-weight:bold;}
.tip{color:#ff3333;margin:10px 0;}
.code{background:#f9f9f9;padding:12px;border:1px dashed #ccc;border-radius:8px;margin:15px 0;font-size:18px;}
.tabs{display:flex;margin-bottom:15px;}
.tab{flex:1;padding:10px;background:#f0f0f0;cursor:pointer;border:none;}
.tab.active{background:#1677ff;color:#fff;}
.paybox{display:none;}
.paybox.active{display:block;}
.qrcode img{width:260px;height:260px;margin:10px auto;}
.btn{background:#1677ff;color:#fff;border:none;width:100%;padding:12px;border-radius:8px;margin-top:20px;font-size:16px;}
.success{color:green;font-size:16px;margin:10px 0;}
</style>
<div class="main">
<h2>佳木斯论坛-邀请码购买</h2>
<div class="price">￥1 元/个</div>
<div class="tip">支付时请备注【订单号】：<?=$order_no?></div>
<div class="code">订单号：<?=$order_no?></div>

<button class="tab active" onclick="show('wx')">微信支付</button>
<button class="tab" onclick="show('ali')">支付宝支付</button>

<div class="paybox active" id="wx">
  <div class="qrcode"><img src="<?=$wx_qr?>"></div>
  <p>微信扫码支付 1 元</p>
</div>
<div class="paybox" id="ali">
  <div class="qrcode"><img src="<?=$ali_qr?>"></div>
  <p>支付宝扫码支付 1 元</p>
</div>

<button class="btn" onclick="if(confirm('确认支付完成？')){location.href='plugin.php?id=invite_auto:pay&order=<?=$order_no?>'}">我已支付，获取邀请码</button>

<script>
function show(t){
  document.querySelectorAll('.tab').forEach(x=>x.classList.remove('active'));
  document.querySelectorAll('.paybox').forEach(x=>x.classList.remove('active'));
  event.target.classList.add('active');
  document.getElementById(t).classList.add('active');
}
</script>

<?php
// 自动发码逻辑
if($_GET['order']){
    $order_no = trim($_GET['order']);
    $inv = DB::fetch_first("SELECT * FROM ".DB::table('common_invite')." WHERE order_no='$order_no'");
    if($inv){
        DB::update('common_invite', ['status'=>1], "order_no='$order_no'");
        echo '<div class="code">'.$inv['code'].'</div>';
        echo '<div class="success">✅支付成功！邀请码：'.$inv['code'].'</div>';
        // 发邮件
        if($_G['member']['email']){
            sendmail($_G['member']['email'], '你的邀请码', "邀请码：{$inv['code']}\n有效期7天");
        }
    }
    exit;
}
include template('common/footer');
?>